<?php
$pdo = Db::pdo();
$memberId = (int)($_SESSION['auth']['id'] ?? 0);

$q = trim($_GET['q'] ?? '');
$status = trim($_GET['status'] ?? ''); // pending/active/''

// pagination
$perPage = 25;
$pageNum = (int)($_GET['p'] ?? 1);
if ($pageNum < 1) $pageNum = 1;
$offset = ($pageNum - 1) * $perPage;

// where
$where = "s.sponsor_id = ?";
$params = [$memberId];

if ($status === 'pending' || $status === 'active') {
  $where .= " AND m.status = ?";
  $params[] = $status;
}
if ($q !== '') {
  $where .= " AND (m.username LIKE ? OR m.fullname LIKE ? OR m.phone LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
  $params[] = "%$q%";
}

// total
$st = $pdo->prepare("
  SELECT COUNT(*)
  FROM sponsor_links s
  JOIN members m ON m.id = s.member_id
  WHERE $where
");
$st->execute($params);
$total = (int)$st->fetchColumn();
$totalPages = (int)ceil(max(1, $total) / $perPage);

// rows
$st = $pdo->prepare("
  SELECT
    m.id, m.username, m.fullname, m.status,
    m.parent_id, m.leg,
    s.created_at AS sponsor_date
  FROM sponsor_links s
  JOIN members m ON m.id = s.member_id
  WHERE $where
  ORDER BY s.id DESC
  LIMIT $perPage OFFSET $offset
");
$st->execute($params);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

// ringkasan
$st = $pdo->prepare("
  SELECT
    SUM(CASE WHEN m.status='active' THEN 1 ELSE 0 END) AS active_cnt,
    SUM(CASE WHEN m.status='pending' THEN 1 ELSE 0 END) AS pending_cnt
  FROM sponsor_links s
  JOIN members m ON m.id = s.member_id
  WHERE s.sponsor_id = ?
");
$st->execute([$memberId]);
$sum = $st->fetch(PDO::FETCH_ASSOC);
$activeCnt = (int)($sum['active_cnt'] ?? 0);
$pendingCnt = (int)($sum['pending_cnt'] ?? 0);
?>

<div class="row g-3">
  <div class="col-12">
    <h4 class="mb-0">Sponsor Langsung</h4>
    <div class="text-secondary">
      Total: <b><?= (int)$total ?></b> —
      Active: <b><?= $activeCnt ?></b> —
      Pending: <b><?= $pendingCnt ?></b>
    </div>
  </div>

  <div class="col-12">
    <form class="card border-0 shadow-sm" method="get" action="member.php">
      <input type="hidden" name="page" value="sponsor">
      <div class="card-body">
        <div class="row g-2 align-items-end">
          <div class="col-12 col-md-3">
            <label class="form-label mb-1">Status</label>
            <select name="status" class="form-select">
              <option value="">Semua</option>
              <option value="active" <?= $status==='active'?'selected':'' ?>>Active</option>
              <option value="pending" <?= $status==='pending'?'selected':'' ?>>Pending</option>
            </select>
          </div>

          <div class="col-12 col-md-5">
            <label class="form-label mb-1">Cari</label>
            <input class="form-control" name="q" value="<?= e($q) ?>" placeholder="username / nama / phone">
          </div>

          <div class="col-12 col-md-2">
            <button class="btn btn-dark w-100">
              <i class="bi bi-funnel me-1"></i> Filter
            </button>
          </div>

          <div class="col-12 col-md-2">
            <a class="btn btn-outline-secondary w-100" href="member.php?page=sponsor">Reset</a>
          </div>
        </div>
      </div>
    </form>
  </div>

  <div class="col-12">
    <div class="card border-0 shadow-sm">
      <div class="card-body">
        <h6 class="mb-3">Daftar Member yang Kamu Sponsori</h6>

        <div class="table-responsive">
          <table class="table table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Nama</th>
                <th>Status</th>
                <th>Placement</th>
                <th>Tanggal Sponsor</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td><?= (int)$r['id'] ?></td>
                  <td><?= e($r['username']) ?></td>
                  <td><?= e($r['fullname'] ?? '-') ?></td>
                  <td>
                    <span class="badge <?= ($r['status']==='active')?'bg-success':'bg-secondary' ?>">
                      <?= e(strtoupper($r['status'])) ?>
                    </span>
                  </td>
                  <td class="small">
                    <?php if (!empty($r['parent_id']) && !empty($r['leg'])): ?>
                      Upline #<?= (int)$r['parent_id'] ?> (<?= e($r['leg']) ?>)
                    <?php else: ?>
                      <span class="text-secondary">belum placement</span>
                    <?php endif; ?>
                  </td>
                  <td class="small"><?= e($r['sponsor_date']) ?></td>
                </tr>
              <?php endforeach; ?>

              <?php if (empty($rows)): ?>
                <tr>
                  <td colspan="6" class="text-center text-secondary py-3">Belum ada sponsor.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>

        <?php if ($totalPages > 1): ?>
          <nav class="mt-2">
            <ul class="pagination pagination-sm mb-0">
              <?php
                $base = "member.php?page=sponsor"
                      . "&status=" . urlencode($status)
                      . "&q=" . urlencode($q);
              ?>
              <?php for ($i=1; $i<=$totalPages; $i++): ?>
                <li class="page-item <?= $i===$pageNum ? 'active' : '' ?>">
                  <a class="page-link" href="<?= e($base . "&p=" . $i) ?>"><?= $i ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        <?php endif; ?>

      </div>
    </div>
  </div>
</div>
